﻿#if       !defined(INCLUDED_SZ_ARCHIVE_FILE_UPDATE_CLIENT_CALLBACK)
#define            INCLUDED_SZ_ARCHIVE_FILE_UPDATE_CLIENT_CALLBACK

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_TIME)
#include  <szTime.hpp>
#endif // !defined(INCLUDED_SZ_TIME)

SZ_NS_BEG(szpp)

/// <summary>
/// ファイルをアーカイブファイルに圧縮するめのコールバック型。
/// クライアント側で派生クラスを実装して、そのポインタを SevenZip++ に登録する。
/// </summary>
class SZ_SPEC ArchiveFileUpdateClientCallback
{
public:

  // TODO: ほかの展開クラスと共通の場所に移動
  enum OperationResult
  {
    OK = 0,
    Error
  };

  // IUpdateCallbackUI
  virtual HRESULT SetTotal(const u64 &size) = 0;
  virtual HRESULT SetCompleted(const u64 &completeValue) = 0;
  virtual HRESULT SetRatioInfo(const u64 &inSize, const u64 &outSize) = 0;
  virtual HRESULT CheckBreak() = 0;
  virtual HRESULT Finalize() = 0;
  virtual HRESULT SetNumFiles(const u64 &numFiles) = 0;
  virtual HRESULT GetStream(const szstring &name, bool isAnti) = 0;
  virtual HRESULT OpenFileError(const szstring &name, u32 systemError) = 0;
  virtual HRESULT SetOperationResult(u32 operationResult) = 0;
  virtual HRESULT CryptoGetTextPassword2(u32 *passwordIsDefined, szstring *password) = 0;
  virtual HRESULT CryptoGetTextPassword(szstring *password) = 0;

  // IUpdateCallbackUI2
  virtual HRESULT OpenResult(const szstring &name, HRESULT result) = 0;
  virtual HRESULT StartScanning() = 0;
  virtual HRESULT ScanProgress(const u64 &numFolders, const u64 &numFiles, const szstring &path) = 0;
  virtual HRESULT CanNotFindError(const szstring &name, u32 systemError) = 0;
  virtual HRESULT FinishScanning() = 0;
  virtual HRESULT StartArchive(const szstring &name, bool updating) = 0;
  virtual HRESULT FinishArchive() = 0;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_FILE_UPDATE_CLIENT_CALLBACK)
